/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data.content;

import java.util.ArrayList;
import javax.annotation.Nullable;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.book.repository.BookRepository;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.TextElement;

public abstract class PageContent {
    public static final transient int TITLE_HEIGHT = 16;
    public static final transient int LARGE_TITLE_HEIGHT = 20;
    public transient PageData parent;
    public transient BookRepository source;
    @Nullable
    private Boolean centerTitle;
    @Nullable
    private Boolean largeTitle;

    @Nullable
    public String getTitle() {
        return "";
    }

    public void load() {
    }

    public abstract void build(BookData var1, ArrayList<BookElement> var2, boolean var3);

    private boolean isLarge() {
        if (this.largeTitle != null) {
            return this.largeTitle;
        }
        if (this.parent != null && this.parent.parent != null && this.parent.parent.parent != null) {
            return this.parent.parent.parent.appearance.largePageTitles;
        }
        return false;
    }

    private boolean isCentered() {
        if (this.centerTitle != null) {
            return this.centerTitle;
        }
        if (this.parent != null && this.parent.parent != null && this.parent.parent.parent != null) {
            return this.parent.parent.parent.appearance.centerPageTitles;
        }
        return false;
    }

    protected int getTitleHeight() {
        return this.isLarge() ? 20 : 16;
    }

    public void addTitle(ArrayList<BookElement> list, String titleText) {
        this.addTitle(list, titleText, false);
    }

    public void addTitle(ArrayList<BookElement> list, String titleText, boolean dropShadow) {
        this.addTitle(list, titleText, dropShadow, 0, 0);
    }

    public void addTitle(ArrayList<BookElement> list, String titleText, boolean dropShadow, int color) {
        this.addTitle(list, titleText, dropShadow, color, 0);
    }

    public void addTitle(ArrayList<BookElement> list, String titleText, boolean dropShadow, int color, int y) {
        TextData title = new TextData(titleText);
        boolean isLarge = this.isLarge();
        title.scale = isLarge ? 1.2f : 1.0f;
        title.underlined = true;
        title.dropshadow = dropShadow;
        if (color != 0) {
            title.useOldColor = false;
            title.rgbColor = color;
        }
        int x = 0;
        int w = 182;
        if (this.isCentered()) {
            w = (int)Math.ceil((float)this.parent.parent.parent.fontRenderer.m_92895_(titleText) * title.scale) + 1;
            x = (182 - w) / 2;
        }
        list.add(new TextElement(x, y, w, isLarge ? 11 : 9, title));
    }

    public void addText(ArrayList<BookElement> list, String subText, boolean dropShadow) {
        this.addText(list, subText, dropShadow, 0, 0);
    }

    public void addText(ArrayList<BookElement> list, String subText, boolean dropShadow, int color) {
        this.addText(list, subText, dropShadow, color, 0);
    }

    public int addText(ArrayList<BookElement> list, String text, boolean dropShadow, int color, int y) {
        TextData subText = new TextData(text);
        subText.dropshadow = dropShadow;
        if (color != 0) {
            subText.useOldColor = false;
            subText.rgbColor = color;
        }
        int height = this.parent.parent.parent.fontRenderer.m_92920_(text, 182) * 12 / 9;
        list.add(new TextElement(5, y, 182, height, subText));
        return height;
    }

    public void setCenterTitle(@Nullable Boolean centerTitle) {
        this.centerTitle = centerTitle;
    }

    @Nullable
    public Boolean getCenterTitle() {
        return this.centerTitle;
    }

    public void setLargeTitle(@Nullable Boolean largeTitle) {
        this.largeTitle = largeTitle;
    }

    @Nullable
    public Boolean getLargeTitle() {
        return this.largeTitle;
    }
}

